program in_order;
{$mode objfpc}{$H+}
uses
  CRT, FileUtil;
type
  vector=array of integer;
  PTree= ^Tree;  // Указатель на дерево
  Tree= record   // Само дерево, имеет тип - запись
  node: integer;  // значение вершины (узла) дерева
  left: PTree; // Ссылка на левое поддерево
  right: PTree; // Ссылка на правое поддерево
  end;
var
  i, n, choose:integer;
  Elem: integer;
  sorted_array:vector; // сортируемый массив
  root: PTree;

{Процедура обхода двоичного дерева слева}
procedure obhod(p:PTree);
begin
   if p <> nil then
   begin
      obhod(p^.left);
      write(p^.node, ' ');
      obhod(p^.right);
   end;
end;

{Процедура поиска узла для вставки нового узла}
procedure insert_node(Elem: integer; var root:PTree);
var
  p: ^Tree; // текущий узел
  newTree: ^Tree; // новый узел
begin
  p:= root; // начинаем с корня и проходим до нужного узла
  while (Elem > p^.node) and (p^.right <> nil) or
        (Elem < p^.node) and (p^.left <> nil) do
  if Elem < p^.node then
    p:= p^.left
  else
    p:= p^.right;
  {Создание нового узла}
  New(newTree);
  newTree^.left:= nil;
  newTree^.right:= nil;
  newTree^.node:= Elem;
  {В зависимости от значенич Elem новый
  узел добавляется либо справа, либо слева}
  if Elem > p^.node then
    p^.right:= newTree
  else
    p^.left:= newTree;
end;

  { ============= Сортировка двоичным деревом поиска======== }
procedure Tree_Sort(var sorted_array:vector);
var
  Elem: integer;
begin
  Elem:= sorted_array[0];
  New(root);
  root^.left:= nil;
  root^.right:= nil;
  root^.node:= Elem;
  for i:=1 to High(sorted_array) do
  begin
    Elem:= sorted_array[i];
    insert_node(Elem, root);
  end;
  obhod(root);
end;

{Функция поиска в бинарном дереве}
function Search_Elem(Elem: integer; var root:PTree): boolean;
var
  p: PTree;
begin
  Search_Elem:= false;
  if root = nil then exit;
  p:= root;
  if p^.node = Elem then
    Search_Elem:= true  // элемент найден
  else
    if Elem < p^.node then
       Search_Elem:= Search_Elem(Elem, p^.left)
    else
       Search_Elem:= Search_Elem(Elem, p^.right);
end;

begin
  writeln(UTF8ToConsole('Введите количество элементов массива'));
  readln(n);
  SetLength(sorted_array, n);
  writeln(UTF8ToConsole('Введите элементы массива'));
  for i:= 0 to n - 1 do
    read(sorted_array[i]);
  repeat
    writeln(UTF8ToConsole('Выберите нужное действие:'));
    writeln(UTF8ToConsole('1-сортировка массива'));
    writeln(UTF8ToConsole('2-поиск элемента массива'));
    writeln(UTF8ToConsole('3-выход из программы'));
    readln(choose);
    case choose of
    1: begin {Сортировка}
         {Вызов процедуры сортировки массива бинарным деревом поиска}
         Tree_Sort(sorted_array); writeln;
       end;
    2: begin {поиск}
         writeln(UTF8ToConsole('введите искомый элемент'));
         readln(Elem);
         if Search_Elem(Elem, root)then
           writeln(UTF8ToConsole('Элемент найден'))
         else
           writeln(UTF8ToConsole('Элемент не найден'));
       end;
     end; { end of case }
  until choose = 3;
end.
